const canvas = document.getElementById("gameCanvas");
const ctx = canvas.getContext("2d");
const startScreen = document.getElementById("startScreen");
const startButton = document.getElementById("startButton");

const player = {
  x: 380,
  y: 230,
  size: 40,
  color: "#00bfff",
  speed: 5
};

const keys = {};
let gameStarted = false;

window.addEventListener("keydown", e => {
  if (!gameStarted) return;
  keys[e.key] = true;
});

window.addEventListener("keyup", e => {
  if (!gameStarted) return;
  keys[e.key] = false;
});

startButton.addEventListener("click", () => {
  startScreen.style.display = "none";
  canvas.style.display = "block";
  gameStarted = true;
  gameLoop();
});

function update() {
  if (keys["ArrowLeft"]) player.x -= player.speed;
  if (keys["ArrowRight"]) player.x += player.speed;
  if (keys["ArrowUp"]) player.y -= player.speed;
  if (keys["ArrowDown"]) player.y += player.speed;

  player.x = Math.max(0, Math.min(canvas.width - player.size, player.x));
  player.y = Math.max(0, Math.min(canvas.height - player.size, player.y));
}

function draw() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.fillStyle = player.color;
  ctx.fillRect(player.x, player.y, player.size, player.size);
}

function gameLoop() {
  update();
  draw();
  requestAnimationFrame(gameLoop);
}
