document.addEventListener('DOMContentLoaded', () => {

    // 1. Animasi Scroll Fade-In untuk semua elemen dengan class 'fade-in'
    const fadeElements = document.querySelectorAll('.fade-in, .grid-item');

    const observerOptions = {
        root: null,
        threshold: 0.2 // Item akan dianggap terlihat jika 20% dari item berada di viewport
    };

    const scrollObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible'); 
                observer.unobserve(entry.target);
            }
        });
    }, observerOptions);

    fadeElements.forEach(item => {
        scrollObserver.observe(item);
    });

    // 2. Ripple Effect pada Tombol CTA Utama
    const ctaButton = document.querySelector('.cta-button');
    const projectButtons = document.querySelectorAll('.project-button');
    const submitButton = document.querySelector('.submit-button');
    
    // Fungsi untuk membuat Ripple Effect
    function createRipple(e) {
        const button = e.currentTarget;
        
        // Hapus ripple yang sudah ada
        const existingRipple = button.querySelector('.ripple');
        if (existingRipple) {
            existingRipple.remove();
        }

        // Buat elemen ripple baru
        const circle = document.createElement('span');
        const diameter = Math.max(button.clientWidth, button.clientHeight);
        const radius = diameter / 2;

        // Hitung posisi klik relatif terhadap tombol
        circle.style.width = circle.style.height = `${diameter}px`;
        circle.style.left = `${e.clientX - (button.getBoundingClientRect().left + radius)}px`;
        circle.style.top = `${e.clientY - (button.getBoundingClientRect().top + radius)}px`;
        circle.classList.add('ripple');

        button.appendChild(circle);
    }

    // Terapkan Ripple Effect ke semua tombol yang diinginkan
    if (ctaButton) ctaButton.addEventListener('click', createRipple);
    projectButtons.forEach(btn => btn.addEventListener('click', createRipple));
    if (submitButton) submitButton.addEventListener('click', createRipple);


    // 3. Efek Parallax Sederhana pada Hero Content
    const heroContent = document.querySelector('.hero-content');
    
    window.addEventListener('scroll', () => {
        const scrollPosition = window.scrollY;

        // Konten hero bergerak ke bawah 50% dari kecepatan scroll
        if (heroContent) {
            heroContent.style.transform = `translateY(${scrollPosition * 0.5}px)`;
        }
    });
});