const hamburger = document.querySelector(".hamburger");
const navMenu = document.querySelector(".nav-menu");
const navLinks = document.querySelectorAll(".nav-link");

// Toggle Menu Mobile
hamburger.addEventListener("click", () => {
    hamburger.classList.toggle("aktif");
    navMenu.classList.toggle("aktif");
});

// Tutup menu saat link diklik
navLinks.forEach(link => {
    link.addEventListener("click", () => {
        hamburger.classList.remove("aktif");
        navMenu.classList.remove("aktif");
    });
});

// Animasi Scroll
const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
        if (entry.isIntersecting) {
            entry.target.classList.add('show');
        }
    });
});

const hiddenElements = document.querySelectorAll('.hidden');
hiddenElements.forEach((el) => observer.observe(el));